﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LINQ_to_Objects
{
    public partial class Form1 : Form
    {
        private List<Osoba> listaOsob = new List<Osoba> 
            { 
            new Osoba { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 123456789, Wiek = 35 }, 
            new Osoba { Id = 2, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 246813579, Wiek = 36 },
            new Osoba { Id = 3, Imię = "Karolina", Nazwisko = "Matulewska", NumerTelefonu = 567891234, Wiek = 7 }, 
            new Osoba { Id = 4, Imię = "Bartosz", Nazwisko = "Matulewski", NumerTelefonu = 987654321, Wiek = 2 } 
            };

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string s = "Lista wszystkich osób:\n";
            foreach (var osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
            
            var listaOsobPelnoletnich = from osoba in listaOsob where osoba.Wiek>=18 orderby osoba.Wiek select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            //var listaOsobPelnoletnich = from osoba in listaOsob where osoba.Wiek >= 18 orderby osoba.Wiek select osoba;
            MessageBox.Show("Typ całej listy: "+listaOsobPelnoletnich.GetType().FullName);
            MessageBox.Show("Typ elementów listy: "+listaOsobPelnoletnich.First().GetType().FullName);

            s = "Lista osób pełnoletnich:\n";
            foreach (var osoba in listaOsobPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);

            MessageBox.Show("Wiek najstarszej osoby: " + listaOsobPelnoletnich.Max(osoba => osoba.Wiek));
            var najstarszaOsoba=listaOsobPelnoletnich.Single(osoba1=>(osoba1.Wiek==listaOsobPelnoletnich.Max(osoba => osoba.Wiek)));
            MessageBox.Show("Najstarsza osoba: " + najstarszaOsoba.Imię + " " + najstarszaOsoba.Nazwisko + " (" + najstarszaOsoba.Wiek + ")");
            MessageBox.Show("Średni wiek osób pełnoletnich: " + listaOsobPelnoletnich.Average(osoba => osoba.Wiek));
            MessageBox.Show("Suma lat osób pełnoletnich: " + listaOsobPelnoletnich.Sum(osoba => osoba.Wiek));
            //List<> podlista = listaOsobPelnoletnich.ToList<Osoba>();
            //List<Osoba> podlista = listaOsobPelnoletnich.ToList<Osoba>();

            bool czySpełniaWarunek=listaOsobPelnoletnich.All(osoba => (osoba.Wiek > 18));
            bool czyZawieraPelnoletnią = listaOsob.Any(osoba => (osoba.Wiek > 18));            
            //bool czyZawieraElement=listaOsobPelnoletnich.Contains(listaOsob[0]);

            var listaKobiet = from osoba in listaOsob where osoba.Imię.EndsWith("a") select new { osoba.Imię, osoba.Nazwisko, osoba.Wiek };
            //var listaKobiet = from osoba in listaOsob where osoba.Imię.EndsWith("a") select osoba;
            s = "Lista kobiet\n";
            foreach (var osoba in listaKobiet) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);

            //suma zbiorow
            //var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Concat(listaKobiet).Distinct();
            var listaPelnoletnich_I_Kobiet = listaOsobPelnoletnich.Union(listaKobiet);
            s = "Lista osób pełnoletnich lub kobiet (suma zbiorów)\n";
            foreach (var osoba in listaPelnoletnich_I_Kobiet) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
            //czesc wspolna
            var listaKobietPelnoletnich = listaOsobPelnoletnich.Intersect(listaKobiet);
            s = "Lista pełnoletnich kobiet (część wspólna zbiorów)\n";
            foreach (var osoba in listaKobietPelnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
            var listaPelnoletnichNiekobiet = listaOsobPelnoletnich.Except(listaKobiet);
            s = "Lista osób pełnoletnich nie będących kobietami (różnica zbiorów)\n";
            foreach (var osoba in listaPelnoletnichNiekobiet) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);            

            var listaTelefonów = from osoba in listaOsob select new {osoba.Id, osoba.NumerTelefonu};
            var listaPersonaliów = from osoba in listaOsob select new {osoba.Id, osoba.Imię, osoba.Nazwisko};
            var listaPersonaliówZTelefonami = from telefon in listaTelefonów join personalia in listaPersonaliów on telefon.Id equals personalia.Id select new {telefon.Id, personalia.Imię, personalia.Nazwisko, telefon.NumerTelefonu};
            s = "Pobieranie danych z dwóch źródeł - operator join:\n";
            foreach (var osoba in listaPersonaliówZTelefonami) s += osoba.Imię + " " + osoba.Nazwisko + " " + osoba.NumerTelefonu + "\n";
            MessageBox.Show(s);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            var listaOsobPelnoletnich = from osoba in listaOsob where osoba.Wiek >= 18 orderby osoba.Wiek select osoba;
            //var listaOsobPelnoletnich = from osoba in listaOsob where osoba.Wiek >= 18 orderby osoba.Wiek select new Osoba { Id = osoba.Id, Imię = osoba.Imię, Nazwisko = osoba.Nazwisko, NumerTelefonu = osoba.NumerTelefonu, Wiek = osoba.Wiek };

            Osoba pierwszyNaLiscie=listaOsobPelnoletnich.First<Osoba>();
            pierwszyNaLiscie.Imię="Jan";
            pierwszyNaLiscie.Nazwisko="Kowalski";
            pierwszyNaLiscie.Wiek=24;

            string s = "Lista wszystkich osób:\n";
            foreach (var osoba in listaOsob) s += osoba.Imię + " " + osoba.Nazwisko + "\n";
            MessageBox.Show(s);
        }
    }

    class Osoba
    {
        public int Id;
        public string Imię, Nazwisko;
        public int NumerTelefonu;
        public int Wiek;
    }
}
